define(function () {

    var component = {
        data: function () {
            return {
                current: 0,
                interval: 5000,
                intervalId: null,
                transName: "slideLeft"
            };
        },
        methods: {
            prev: function () {
                var that = this;
                that.transName = "slideRight";
                that.current =
                    that.current === 0 ? that.users.length - 1 : that.current - 1;
            },
            next: function () {
                var that = this;
                that.transName = "slideLeft";
                that.current = (that.current + 1) % that.users.length;
            },
            timerJob: function () {
                if (this.intervalId)
                    clearInterval(this.intervalId);
                if (this.webpartProperties.autoRotate == true) {
                    this.intervalId = setInterval(this.next, this.interval);
                }
            }
        },
        computed: {
            autoRotation: function () {
                return this.webpartProperties.autoRotate;
            }
        },
        watch: {
            autoRotation: function (value) {
                this.timerJob();
            }
        },
        created: function () {
            this.timerJob();
        }
    };

    component.originalTemplate = "Rotator";
    component.template = `
<wizdomWebpart data-v-09344f61
  :environmentInfo="environmentInfo"
  :chromeProperties="webpartProperties.chromeProperties"
  :title="'Department Staff' | translate"
  @titleChanged="webpartProperties.title = event"
  :dynamicData="users?users.length:null" chromeType="visual" :webpartPadding="true" :paddingSides="0"
  @webpart-resize="webpartResize"
>
  <div data-v-09344f61 class="department-staff-container">
    <div data-v-09344f61 class="msg" v-if="users==null">{{ "Loading ..." | translate }}</div>
    <div data-v-09344f61 class="msg" v-else-if="users.length==0">{{ "No users in department(s)" | translate }}</div>
    <div data-v-09344f61 v-else class="department-staff">
      <div data-v-09344f61 class="left-nav clickable">
          <a data-v-09344f61 v-on:click.prevent="prev()">
            <span data-v-09344f61 class="ms-Icon ms-Icon--DoubleChevronLeftMed"></span>
          </a>
        </div>
      <div data-v-09344f61 class="nav-body">
      <transition data-v-09344f61 :name="transName" v-for="(user,index) in users" :key="user.accountName">
        <div data-v-09344f61 class="ms-Persona persona-margin ms-Persona--xl" v-show="index==current" @swipeleft="next()" @swiperight="prev()">
          <div data-v-09344f61 class="ms-Persona-imageArea">
            <a data-v-09344f61 :href="user.publicUrl">
              <img data-v-09344f61 class="ms-Persona-image" :src="user.pictureUrl.replace('?size=M','?size=L')">
            </a>
          </div>
          <div data-v-09344f61 class="ms-Persona-details">
            <div data-v-09344f61 class="ms-Persona-primaryText">
              <a data-v-09344f61 :href="user.publicUrl">{{user.name}}</a>
            </div>
            <div data-v-09344f61 class="ms-Persona-secondaryText">
              <a data-v-09344f61 :href="'mailto:' + user.email">{{user.email}}</a>
            </div>
            <div data-v-09344f61 class="ms-Persona-secondaryText">{{user.department}}</div>
          </div>
        </div>
      </transition>
      </div>
      <div data-v-09344f61 class="right-nav clickable">
          <a data-v-09344f61 v-on:click.prevent="next()">
            <span data-v-09344f61 class="ms-Icon ms-Icon--DoubleChevronLeftMedMirrored"></span>
          </a>
        </div>
    </div>
  </div>
</wizdomWebpart>
`;
    component.styles = `
/*
  Your use of the content in the files referenced here are subject to the terms of the license at http://aka.ms/fabric-font-license
*/
.ms-Persona[data-v-09344f61] {
  font-family: "Segoe UI WestEuropean", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
  -webkit-font-smoothing: antialiased;
  box-sizing: border-box;
  margin: 0;
  padding: 0;
  -webkit-box-shadow: none;
  -moz-box-shadow: none;
  box-shadow: none;
  color: #333333;
  font-size: 14px;
  font-weight: 400;
  line-height: 1;
  position: relative;
  width: 100%;
  height: 48px;
  display: table;
  table-layout: fixed;
  border-collapse: separate;
}
.ms-Persona .ms-ContextualHost[data-v-09344f61] {
    display: none;
}
.ms-Persona-imageArea[data-v-09344f61] {
  position: absolute;
  overflow: hidden;
  text-align: center;
  max-width: 48px;
  height: 48px;
  border-radius: 50%;
  z-index: 0;
  width: 100%;
  top: 0;
  left: 0;
}
@media screen and (-ms-high-contrast: active) {
.ms-Persona-imageArea[data-v-09344f61] {
      border: 1px solid #ffffff;
}
}
@media screen and (-ms-high-contrast: black-on-white) {
.ms-Persona-imageArea[data-v-09344f61] {
      border: 1px solid #000000;
}
}
.ms-Persona-placeholder[data-v-09344f61] {
  color: #ffffff;
  position: absolute;
  right: 0;
  left: 0;
  font-size: 47px;
  top: 9px;
  z-index: 5;
}
.ms-Persona-initials[data-v-09344f61] {
  color: #ffffff;
  font-size: 17px;
  font-weight: 100;
  line-height: 48px;
}
.ms-Persona-initials.ms-Persona-initials--blueLight[data-v-09344f61] {
    background-color: #00bcf2;
}
.ms-Persona-initials.ms-Persona-initials--blue[data-v-09344f61] {
    background-color: #0078d7;
}
.ms-Persona-initials.ms-Persona-initials--blueDark[data-v-09344f61] {
    background-color: #002050;
}
.ms-Persona-initials.ms-Persona-initials--teal[data-v-09344f61] {
    background-color: #008272;
}
.ms-Persona-initials.ms-Persona-initials--greenLight[data-v-09344f61] {
    background-color: #bad80a;
}
.ms-Persona-initials.ms-Persona-initials--green[data-v-09344f61] {
    background-color: #107c10;
}
.ms-Persona-initials.ms-Persona-initials--greenDark[data-v-09344f61] {
    background-color: #004b1c;
}
.ms-Persona-initials.ms-Persona-initials--magentaLight[data-v-09344f61] {
    background-color: #e3008c;
}
.ms-Persona-initials.ms-Persona-initials--magenta[data-v-09344f61] {
    background-color: #b4009e;
}
.ms-Persona-initials.ms-Persona-initials--purpleLight[data-v-09344f61] {
    background-color: #b4a0ff;
}
.ms-Persona-initials.ms-Persona-initials--purple[data-v-09344f61] {
    background-color: #5c2d91;
}
.ms-Persona-initials.ms-Persona-initials--black[data-v-09344f61] {
    background-color: #000000;
}
.ms-Persona-initials.ms-Persona-initials--orange[data-v-09344f61] {
    background-color: #d83b01;
}
.ms-Persona-initials.ms-Persona-initials--red[data-v-09344f61] {
    background-color: #e81123;
}
.ms-Persona-initials.ms-Persona-initials--redDark[data-v-09344f61] {
    background-color: #a80000;
}
.ms-Persona-image[data-v-09344f61] {
  position: absolute;
  top: 0;
  left: 0;
  height: 48px;
  z-index: 10;
  width: 100%;
}

.ms-Persona-presence[data-v-09344f61] {
  background-color: #7FBA00;
  position: absolute;
  height: 12px;
  width: 12px;
  border-radius: 50%;
  top: auto;
  left: 34px;
  bottom: -1px;
  border: 2px solid #ffffff;
  text-align: center;
}
@media screen and (-ms-high-contrast: active) {
.ms-Persona-presence[data-v-09344f61] {
      border-color: #000000;
      box-shadow: 0 0 0 1px #1AEBFF inset;
      color: #000000;
      background-color: #ffffff;
}
}
@media screen and (-ms-high-contrast: black-on-white) {
.ms-Persona-presence[data-v-09344f61] {
      border-color: #ffffff;
      box-shadow: 0 0 0 1px #37006E inset;
      color: #ffffff;
      background-color: #000000;
}
}
.ms-Persona-presenceIcon[data-v-09344f61] {
  color: #ffffff;
  font-size: 8px;
  line-height: 12px;
  vertical-align: top;
}
.ms-Persona-details[data-v-09344f61] {
  padding: 0 12px;
  vertical-align: middle;
  overflow: hidden;
  text-align: left;
  padding-left: 60px;
  display: table-cell;
  width: 100%;
}
.ms-Persona-primaryText[data-v-09344f61],
.ms-Persona-secondaryText[data-v-09344f61],
.ms-Persona-tertiaryText[data-v-09344f61],
.ms-Persona-optionalText[data-v-09344f61] {
  display: block;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
  width: 100%;
  overflow: hidden;
  text-overflow: ellipsis;
}
.ms-Persona-primaryText[data-v-09344f61] {
  color: #333333;
  font-weight: 400;
  font-size: 17px;
  margin-top: -3px;
  line-height: 1.4;
}
.ms-Persona-secondaryText[data-v-09344f61],
.ms-Persona-tertiaryText[data-v-09344f61],
.ms-Persona-optionalText[data-v-09344f61] {
  color: #666666;
  font-weight: 400;
  font-size: 12px;
  white-space: nowrap;
  line-height: 1.3;
}
.ms-Persona-secondaryText[data-v-09344f61] {
  padding-top: 3px;
}
.ms-Persona-tertiaryText[data-v-09344f61],
.ms-Persona-optionalText[data-v-09344f61] {
  padding-top: 5px;
  display: none;
}
.ms-Persona.ms-Persona--tiny[data-v-09344f61] {
  height: 30px;
  display: inline-block;
}
.ms-Persona.ms-Persona--tiny .ms-Persona-imageArea[data-v-09344f61] {
    overflow: visible;
    display: none;
}
.ms-Persona.ms-Persona--tiny .ms-Persona-presence[data-v-09344f61] {
    right: auto;
    top: 10px;
    left: 0;
    border: 0;
}
@media screen and (-ms-high-contrast: active) {
.ms-Persona.ms-Persona--tiny .ms-Persona-presence[data-v-09344f61] {
        top: 9px;
        border: 1px solid #ffffff;
}
}
@media screen and (-ms-high-contrast: black-on-white) {
.ms-Persona.ms-Persona--tiny .ms-Persona-presence[data-v-09344f61] {
        border: 1px solid #000000;
}
}
.ms-Persona.ms-Persona--tiny .ms-Persona-details[data-v-09344f61] {
    padding-left: 20px;
}
.ms-Persona.ms-Persona--tiny .ms-Persona-primaryText[data-v-09344f61] {
    font-size: 14px;
    padding-top: 9px;
}
.ms-Persona.ms-Persona--tiny .ms-Persona-secondaryText[data-v-09344f61] {
    display: none;
}
.ms-Persona.ms-Persona--tiny.ms-Persona--readonly[data-v-09344f61] {
  padding: 0;
  background-color: transparent;
}
.ms-Persona.ms-Persona--tiny.ms-Persona--readonly .ms-Persona-primaryText[data-v-09344f61]::after {
    content: ';';
}
.ms-Persona.ms-Persona--xs[data-v-09344f61],
.ms-Persona.ms-Persona--facePile[data-v-09344f61],
.ms-Persona.ms-Persona--token[data-v-09344f61] {
  height: 32px;
}
.ms-Persona.ms-Persona--xs .ms-Persona-imageArea[data-v-09344f61],
  .ms-Persona.ms-Persona--xs .ms-Persona-image[data-v-09344f61],
  .ms-Persona.ms-Persona--facePile .ms-Persona-imageArea[data-v-09344f61],
  .ms-Persona.ms-Persona--facePile .ms-Persona-image[data-v-09344f61],
  .ms-Persona.ms-Persona--token .ms-Persona-imageArea[data-v-09344f61],
  .ms-Persona.ms-Persona--token .ms-Persona-image[data-v-09344f61] {
    max-width: 32px;
    height: 32px;
}
.ms-Persona.ms-Persona--xs .ms-Persona-placeholder[data-v-09344f61],
  .ms-Persona.ms-Persona--facePile .ms-Persona-placeholder[data-v-09344f61],
  .ms-Persona.ms-Persona--token .ms-Persona-placeholder[data-v-09344f61] {
    font-size: 28px;
    top: 6px;
}
.ms-Persona.ms-Persona--xs .ms-Persona-initials[data-v-09344f61],
  .ms-Persona.ms-Persona--facePile .ms-Persona-initials[data-v-09344f61],
  .ms-Persona.ms-Persona--token .ms-Persona-initials[data-v-09344f61] {
    font-size: 12px;
    line-height: 32px;
}
.ms-Persona.ms-Persona--xs .ms-Persona-presence[data-v-09344f61],
  .ms-Persona.ms-Persona--facePile .ms-Persona-presence[data-v-09344f61],
  .ms-Persona.ms-Persona--token .ms-Persona-presence[data-v-09344f61] {
    left: 19px;
}
.ms-Persona.ms-Persona--xs .ms-Persona-details[data-v-09344f61],
  .ms-Persona.ms-Persona--facePile .ms-Persona-details[data-v-09344f61],
  .ms-Persona.ms-Persona--token .ms-Persona-details[data-v-09344f61] {
    padding-left: 40px;
}
.ms-Persona.ms-Persona--xs .ms-Persona-primaryText[data-v-09344f61],
  .ms-Persona.ms-Persona--facePile .ms-Persona-primaryText[data-v-09344f61],
  .ms-Persona.ms-Persona--token .ms-Persona-primaryText[data-v-09344f61] {
    font-size: 14px;
    padding-top: 3px;
}
.ms-Persona.ms-Persona--xs .ms-Persona-secondaryText[data-v-09344f61],
  .ms-Persona.ms-Persona--facePile .ms-Persona-secondaryText[data-v-09344f61],
  .ms-Persona.ms-Persona--token .ms-Persona-secondaryText[data-v-09344f61] {
    display: none;
}
.ms-Persona.ms-Persona--sm[data-v-09344f61] {
  height: 40px;
}
.ms-Persona.ms-Persona--sm .ms-Persona-imageArea[data-v-09344f61],
  .ms-Persona.ms-Persona--sm .ms-Persona-image[data-v-09344f61] {
    max-width: 40px;
    height: 40px;
}
.ms-Persona.ms-Persona--sm .ms-Persona-placeholder[data-v-09344f61] {
    font-size: 38px;
    top: 5px;
}
.ms-Persona.ms-Persona--sm .ms-Persona-initials[data-v-09344f61] {
    font-size: 14px;
    line-height: 40px;
}
.ms-Persona.ms-Persona--sm .ms-Persona-presence[data-v-09344f61] {
    left: 27px;
}
.ms-Persona.ms-Persona--sm .ms-Persona-details[data-v-09344f61] {
    padding-left: 48px;
}
.ms-Persona.ms-Persona--sm .ms-Persona-primaryText[data-v-09344f61] {
    font-size: 14px;
}
.ms-Persona.ms-Persona--sm .ms-Persona-primaryText[data-v-09344f61],
  .ms-Persona.ms-Persona--sm .ms-Persona-secondaryText[data-v-09344f61] {
    padding-top: 1px;
}
.ms-Persona.ms-Persona--lg[data-v-09344f61] {
  height: 72px;
}
.ms-Persona.ms-Persona--lg .ms-Persona-imageArea[data-v-09344f61],
  .ms-Persona.ms-Persona--lg .ms-Persona-image[data-v-09344f61] {
    max-width: 72px;
    height: 72px;
}
.ms-Persona.ms-Persona--lg .ms-Persona-placeholder[data-v-09344f61] {
    font-size: 67px;
    top: 10px;
}
.ms-Persona.ms-Persona--lg .ms-Persona-initials[data-v-09344f61] {
    font-size: 28px;
    line-height: 72px;
}
.ms-Persona.ms-Persona--lg .ms-Persona-presence[data-v-09344f61] {
    left: 49px;
    height: 20px;
    width: 20px;
    border-width: 3px;
}
.ms-Persona.ms-Persona--lg .ms-Persona-presenceIcon[data-v-09344f61] {
    line-height: 20px;
    font-size: 14px;
}
.ms-Persona.ms-Persona--lg .ms-Persona-details[data-v-09344f61] {
    padding-left: 84px;
}
.ms-Persona.ms-Persona--lg .ms-Persona-secondaryText[data-v-09344f61] {
    padding-top: 3px;
}
.ms-Persona.ms-Persona--lg .ms-Persona-tertiaryText[data-v-09344f61] {
    padding-top: 5px;
    display: block;
}
.ms-Persona.ms-Persona--xl[data-v-09344f61] {
  height: 100px;
}
.ms-Persona.ms-Persona--xl .ms-Persona-imageArea[data-v-09344f61],
  .ms-Persona.ms-Persona--xl .ms-Persona-image[data-v-09344f61] {
    max-width: 100px;
    height: 100px;
}
.ms-Persona.ms-Persona--xl .ms-Persona-placeholder[data-v-09344f61] {
    font-size: 95px;
    top: 12px;
}
.ms-Persona.ms-Persona--xl .ms-Persona-initials[data-v-09344f61] {
    font-size: 42px;
    line-height: 100px;
}
.ms-Persona.ms-Persona--xl .ms-Persona-presence[data-v-09344f61] {
    height: 28px;
    width: 28px;
    left: 71px;
    border-width: 4px;
}
.ms-Persona.ms-Persona--xl .ms-Persona-presenceIcon[data-v-09344f61] {
    line-height: 28px;
    font-size: 21px;
    position: relative;
    top: 1px;
}
.ms-Persona.ms-Persona--xl .ms-Persona-details[data-v-09344f61] {
    padding-left: 120px;
}
.ms-Persona.ms-Persona--xl .ms-Persona-primaryText[data-v-09344f61] {
    font-size: 21px;
    font-weight: 300;
    margin-top: 0;
}
.ms-Persona.ms-Persona--xl .ms-Persona-secondaryText[data-v-09344f61] {
    padding-top: 2px;
}
.ms-Persona.ms-Persona--xl .ms-Persona-tertiaryText[data-v-09344f61],
  .ms-Persona.ms-Persona--xl .ms-Persona-optionalText[data-v-09344f61] {
    padding-top: 5px;
    display: block;
}
.ms-Persona.ms-Persona--darkText .ms-Persona-primaryText[data-v-09344f61] {
  color: #212121;
}
.ms-Persona.ms-Persona--darkText .ms-Persona-secondaryText[data-v-09344f61],
.ms-Persona.ms-Persona--darkText .ms-Persona-tertiaryText[data-v-09344f61],
.ms-Persona.ms-Persona--darkText .ms-Persona-optionalText[data-v-09344f61] {
  color: #333333;
}
.ms-Persona.ms-Persona--selectable[data-v-09344f61] {
  cursor: pointer;
  padding: 0 10px;
}
.ms-Persona.ms-Persona--selectable[data-v-09344f61]:not(.ms-Persona--xl):hover, .ms-Persona.ms-Persona--selectable[data-v-09344f61]:not(.ms-Persona--xl):focus {
    background-color: #deecf9;
    outline: 1px solid transparent;
}
.ms-Persona.ms-Persona--available .ms-Persona-presence[data-v-09344f61] {
  background-color: #7FBA00;
}
.ms-Persona.ms-Persona--away .ms-Persona-presence[data-v-09344f61] {
  background-color: #FCD116;
}
.ms-Persona.ms-Persona--away .ms-Persona-presenceIcon[data-v-09344f61] {
  position: relative;
  left: 1px;
}
.ms-Persona.ms-Persona--blocked .ms-Persona-presence[data-v-09344f61] {
  background-color: #ffffff;
}
.ms-Persona.ms-Persona--blocked .ms-Persona-presence[data-v-09344f61]::before {
    content: '';
    width: 100%;
    height: 100%;
    position: absolute;
    top: 0;
    left: 0;
    box-shadow: 0 0 0 2px #D93B3B inset;
    border-radius: 50%;
}
.ms-Persona.ms-Persona--blocked .ms-Persona-presence[data-v-09344f61]::after {
    content: '';
    width: 100%;
    height: 2px;
    background-color: #D93B3B;
    transform: rotate(-45deg);
    position: absolute;
    top: 5px;
    left: 0;
}
.ms-Persona.ms-Persona--blocked.ms-Persona--lg .ms-Persona-presence[data-v-09344f61]::after {
  top: 9px;
}
.ms-Persona.ms-Persona--blocked.ms-Persona--xl .ms-Persona-presence[data-v-09344f61]::after {
  top: 13px;
}
.ms-Persona.ms-Persona--busy .ms-Persona-presence[data-v-09344f61] {
  background-color: #D93B3B;
}
@media screen and (-ms-high-contrast: active) {
.ms-Persona.ms-Persona--busy .ms-Persona-presence[data-v-09344f61] {
      background-color: #1AEBFF;
}
}
@media screen and (-ms-high-contrast: black-on-white) {
.ms-Persona.ms-Persona--busy .ms-Persona-presence[data-v-09344f61] {
      background-color: #37006E;
}
}
.ms-Persona.ms-Persona--dnd .ms-Persona-presence[data-v-09344f61] {
  background-color: #E81123;
}
.ms-Persona.ms-Persona--offline .ms-Persona-presence[data-v-09344f61] {
  background-color: #93ABBD;
}
@media screen and (-ms-high-contrast: active) {
.ms-Persona.ms-Persona--offline .ms-Persona-presence[data-v-09344f61] {
      background-color: #000000;
      box-shadow: 0 0 0 1px #ffffff inset;
}
}
@media screen and (-ms-high-contrast: black-on-white) {
.ms-Persona.ms-Persona--offline .ms-Persona-presence[data-v-09344f61] {
      background-color: #ffffff;
      box-shadow: 0 0 0 1px #000000 inset;
}
}
.ms-Persona.ms-Persona--facePile[data-v-09344f61] {
  display: inline-block;
  width: auto;
}
.ms-Persona.ms-Persona--facePile[data-v-09344f61]:hover {
    cursor: pointer;
}
.ms-Persona.ms-Persona--facePile .ms-Persona-imageArea[data-v-09344f61] {
    position: relative;
    width: 100%;
    min-width: 32px;
}
.ms-Persona.ms-Persona--facePile .ms-Persona-initials[data-v-09344f61] {
    position: relative;
}
.ms-Persona.ms-Persona--facePile .ms-Persona-details[data-v-09344f61] {
    display: none;
}
.ms-Persona.ms-Persona--facePile .ms-Persona-presence[data-v-09344f61] {
    display: none;
}
.ms-Persona.ms-Persona--token[data-v-09344f61] {
  display: inline-flex;
  width: auto;
  background-color: #f4f4f4;
  border-radius: 20px;
  margin: 4px;
}
.ms-Persona.ms-Persona--token[data-v-09344f61]:hover {
    cursor: pointer;
}
.ms-Persona.ms-Persona--token .ms-Persona-actionIcon[data-v-09344f61] {
    border-radius: 20px;
    display: inline-block;
    width: 32px;
    height: 32px;
    padding: 0;
    line-height: 30px;
    transition: background-color 0.167s cubic-bezier(0.1, 0.9, 0.2, 1);
    text-align: center;
}
.ms-Persona.ms-Persona--token .ms-Persona-actionIcon[data-v-09344f61]:hover {
      background-color: #eaeaea;
}
.ms-Persona.ms-Persona--token .ms-Persona-imageArea[data-v-09344f61] {
    width: 100%;
    min-width: 32px;
}
.ms-Persona.ms-Persona--token .ms-Persona-details[data-v-09344f61] {
    height: 30px;
    display: inline-block;
    width: auto;
    padding-right: 8px;
}
.ms-Persona.ms-Persona--token .ms-Persona-primaryText[data-v-09344f61] {
    padding-top: 0;
    line-height: 34px;
}
.ms-Persona.ms-Persona--token .ms-Persona-initials[data-v-09344f61] {
    position: relative;
}
.department-staff-container[data-v-09344f61] {
  position: relative;
  overflow: hidden;
  /*sliding*/
}
.department-staff-container .msg[data-v-09344f61] {
    color: "[theme:neutralPrimary, default:#333333]";
}
.department-staff-container .department-staff .persona-margin[data-v-09344f61] {
    margin-bottom: 20px;
}
.department-staff-container .department-staff .ms-Persona-primaryText a[data-v-09344f61], .department-staff-container .department-staff .ms-Persona-secondaryText[data-v-09344f61], .department-staff-container .department-staff .ms-Persona-secondaryText a[data-v-09344f61] {
    text-decoration: none;
    color: "[theme:neutralPrimary, default:#333333]";
}
.department-staff-container .department-staff .left-nav[data-v-09344f61] {
    position: absolute;
    bottom: 55px;
    z-index: 0;
    left: 0px;
    color: "[theme:neutralPrimary, default:#333333]";
}
.department-staff-container .department-staff .right-nav[data-v-09344f61] {
    position: absolute;
    bottom: 55px;
    z-index: 0;
    right: 0px;
    color: "[theme:neutralPrimary, default:#333333]";
}
.department-staff-container .department-staff .nav-body[data-v-09344f61] {
    margin: 0 25px;
    overflow: hidden;
}
.department-staff-container .department-staff .nav-body .ms-Persona.ms-Persona--xl[data-v-09344f61] {
      float: left;
}
.department-staff-container .slideLeft-enter[data-v-09344f61] {
    transform: translateX(100%);
}
.department-staff-container .slideLeft-enter-to[data-v-09344f61] {
    transform: translateX(0);
}
.department-staff-container .slideLeft-enter-active[data-v-09344f61] {
    position: absolute;
}
.department-staff-container .slideLeft-leave[data-v-09344f61] {
    transform: translateX(0);
}
.department-staff-container .slideLeft-leave-to[data-v-09344f61] {
    transform: translateX(-100%);
}
.department-staff-container .slideLeft-enter-active[data-v-09344f61],
  .department-staff-container .slideLeft-leave-active[data-v-09344f61] {
    transition: all 500ms ease-in-out;
}
.department-staff-container .slideRight-enter[data-v-09344f61] {
    transform: translateX(-100%);
}
.department-staff-container .slideRight-enter-to[data-v-09344f61] {
    transform: translateX(0);
}
.department-staff-container .slideRight-enter-active[data-v-09344f61] {
    position: absolute;
}
.department-staff-container .slideRight-leave[data-v-09344f61] {
    transform: translateX(0);
}
.department-staff-container .slideRight-leave-to[data-v-09344f61] {
    transform: translateX(200%);
}
.department-staff-container .slideRight-enter-active[data-v-09344f61],
  .department-staff-container .slideRight-leave-active[data-v-09344f61] {
    transition: all 500ms ease-in-out;
}


`;

    return component;

});
